/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.drawables.device.v2_1;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePlacement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class DeviceText
implements Drawable,
RelativePlacement {
    String string_;
    int x_;
    int y_;
    int placement_;
    Font font_;
    Color color_;

    public DeviceText(String string, int x, int y, int placement, Color color, Font font) {
        this.string_ = string;
        this.x_ = x;
        this.y_ = y;
        this.placement_ = placement;
        this.color_ = color;
        this.font_ = font;
    }

    public String getText() {
        return this.string_;
    }

    public void setText(String string) {
        this.string_ = string;
    }

    public void drawOn(Canvas3D canvas, Graphics g) {
        int y;
        int x;
        g.setFont(this.font_);
        g.setColor(this.color_);
        FontMetrics metrics = g.getFontMetrics();
        int stringWidth = metrics.stringWidth(this.string_);
        switch (this.placement_) {
            case 0: 
            case 3: {
                x = (int)((double)this.x_ - (double)stringWidth / 2.0 + 0.5);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                x = this.x_ - stringWidth;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                x = this.x_;
                break;
            }
            default: {
                System.err.println("DeviceText: Bad placement specification");
                return;
            }
        }
        switch (this.placement_) {
            case 3: 
            case 4: 
            case 5: {
                y = this.y_;
                break;
            }
            case 0: 
            case 6: 
            case 7: {
                y = this.y_ + metrics.getAscent();
                break;
            }
            case 1: 
            case 2: {
                y = (int)((double)this.y_ + (double)metrics.getAscent() / 2.0 + 0.5);
                break;
            }
            default: {
                System.err.println("DeviceText: Bad placement specification");
                return;
            }
        }
        g.drawString(this.string_, x, y);
    }
}

